/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.FunctionResultContext$CallbackResultContext;
import com.sun.jna.Klass;
import com.sun.jna.LastErrorException;
import com.sun.jna.NativeMapped;

public abstract class IntegerType
extends Number
implements NativeMapped {
    private static final long serialVersionUID = 1L;
    private boolean unsigned;
    private Number number;
    private long value;
    private int size;

    public static <T extends IntegerType> int compare(T v1, T v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        return IntegerType.compare(v1.longValue(), v2.longValue());
    }

    public IntegerType(int size, long value, boolean unsigned) {
        this.size = size;
        this.unsigned = unsigned;
        this.setValue(value);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    @Override
    public Object toNative() {
        return this.number;
    }

    public IntegerType(int size) {
        this(size, 0L, false);
    }

    public IntegerType(int size, boolean unsigned) {
        this(size, 0L, unsigned);
    }

    @Override
    public Class<?> nativeType() {
        return this.number.getClass();
    }

    public static final int compare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    public IntegerType(int size, long value) {
        this(size, value, false);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object rhs) {
        if (!(rhs instanceof IntegerType)) return false;
        if (!this.number.equals(((IntegerType)rhs).number)) return false;
        return true;
    }

    public String toString() {
        return this.number.toString();
    }

    public static int compare(IntegerType v1, long v2) {
        if (v1 == null) {
            return 1;
        }
        return IntegerType.compare(v1.longValue(), v2);
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    public void setValue(long value) {
        long truncated = value;
        this.value = value;
        switch (this.size) {
            case 1: {
                if (this.unsigned) {
                    this.value = value & 0xFFL;
                }
                truncated = (byte)value;
                this.number = (byte)value;
                break;
            }
            case 2: {
                if (this.unsigned) {
                    this.value = value & 0xFFFFL;
                }
                truncated = (short)value;
                this.number = (short)value;
                break;
            }
            case 4: {
                if (this.unsigned) {
                    this.value = value & 0xFFFFFFFFL;
                }
                truncated = (int)value;
                this.number = (int)value;
                break;
            }
            case 8: {
                this.number = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u7257\uac96\u2928\u3277\u16ee\u7f9c\u97e4\uc5d8\ub4cd\u6c89\u7825\u9f57\ud874\uf4e2\ufeef\ue58d\u60bd\u50ce")) + this.size);
            }
        }
        if (this.size < 8) {
            long mask = (1L << this.size * 8) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if (value < 0L && truncated != value || value >= 0L && (mask & value) != 0L) {
                throw new IllegalArgumentException(LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u723a\uacf3\u2945\u320e\u168a\u7ff0\u979c\uc5a7\ub4e0\u6ce3\u7859\u9f62\ud80b\uf497\ufecc\ue5a1\u6086")) + Long.toHexString(value) + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u7222\uac9d\u2923\u3261\u16fb\u7f89\u97ef\uc5d9\ub499\u6c82\u7820\u9f03\ud86e\uf4fd\ufef0\ue5c8\u60e4\u508f\udba7\ua865\ue625\ude29\u7d7c\ucc40\u75dc\u2b2e")) + this.size + LastErrorException.l(FunctionResultContext$CallbackResultContext.p("\u725b\uace3\u295b\u320f\u1682\u7fe6\u97db\uc5f3\ub4ad\u6cf4\u784b\u9f65\ud843\uf4c2\ufe94")) + Long.toHexString(mask));
            }
        }
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        long value = nativeValue == null ? 0L : ((Number)nativeValue).longValue();
        IntegerType number = (IntegerType)Klass.newInstance(this.getClass());
        number.setValue(value);
        return number;
    }
}

